function init_form() {
    // set the focus
	$('#foldernum').focus(function(){
		var that = this;
		window.setTimeout(function() { that.selectionStart = that.selectionEnd = 10000; }, 0);
	});
    $('#foldernum').focus();

	// handle input field input
    $('#foldernum').on('change keypress keyup keydown paste input', function() {
    	// for a text input, we can truncate the field to the maxLength attribute (make sure we have the attribute!!)
    	if (this.value.length > this.maxLength) {
			this.value = this.value.substr(0, this.maxLength);
		}
    	if (/^[a-zA-Z%_]{1,3}[\d%_]{1,7}$/.test(this.value)) { // specialized folder number regex
			$('#submitBtn').prop('disabled', false);
			$('#formHELP').hide();
		}
		else {
			$('#submitBtn').prop('disabled', true); // doesn't match the regex, submit button disabled
			$('#formHELP').show();
		}
	});
    $('#foldernum').trigger('input');
}
