function init_form() {
    // set the focus
	$('#streetname').focus(function(){
		var that = this;
		window.setTimeout(function() { that.selectionStart = that.selectionEnd = 10000; }, 0);
	});
    $('#streetname').focus();

	// handle input field input
    $('#streetname').on('change keypress keyup keydown paste input', function() {
    	// for a text input, we can truncate the field to the maxLength attribute (make sure we have the attribute!!)
    	if (this.value.length > this.maxLength) {
			this.value = this.value.substr(0, this.maxLength);
		}
		// std min 3 char text regex, allows database wildcards (%|_)
    	if (this.value && (this.value.match(/[^a-zA-Z0-9 \-%_]/g) === null) && ((this.value.match(/[a-zA-Z0-9 \-]/g) === null) ? false : (this.value.match(/[a-zA-Z0-9 \-]/g).length >= 3))) {
			$('#submitBtn').prop('disabled', false);
			$('#formHELP').hide();
		}
		else {
			$('#submitBtn').prop('disabled', true); // doesn't match the regex, submit button disabled
			$('#formHELP').show();
		}
	});
    $('#streetname').trigger('input');
}
